﻿var copyImportationFrom = {
    context: $(".v-copyImportationFrom"),
    datatable: null,
    initialize: function () {
        $(".h-projects", copyImportationFrom.context).a4autocomplete({
            ajaxAction: a4.getProjectAction("GetProjectsForAutocomplete", "Importation"),
            altValueField: $("#SourceProjectId", copyImportationFrom.context),
            valueProperty: "Id",
            labelProperty: "Name",
            categoryProperty: "FolderName",
            select: function (event, data) {
                if (copyImportationFrom.datatable) {
                    copyImportationFrom.datatable.a4datatable("option", "ajaxParams", { "sourceProjectId": data.item.Id });
                    copyImportationFrom.datatable.a4datatable("refresh", true);
                }
                else {
                    copyImportationFrom.initializeDataTable(data.item.Id);
                }
            }
        });

        var projectId = $("#SourceProjectId", copyImportationFrom.context).val();

        if (!isNaN(projectId) && projectId > 0) {
            copyImportationFrom.initializeDataTable(projectId);
        }
    },
    initializeDataTable: function (projectId) {
        this.datatable = $(".h-importationsTable", copyImportationFrom.context).a4datatable({
            displayColumnSelector: false,
            displaySearchBox: false,
            allowRowSelection: true,
            ajaxAction: a4.getProjectAction("GetImportationsForCopy", "Importation"),
            ajaxParams: { "sourceProjectId": projectId },
            defaultSorting: "Id",
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false },
                { "Name": "Title", "Title": resources.Title, "Data": "Title" },
                { "Name": "DtsType", "Title": resources.DataSourceType, "Data": "DtsTypeDescription" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "CreatedOn", "Title": resources.CreatedOn, "Data": "CreatedOn", "Type": "date" }
            ],
            selectRow: function (event, data) {
                copyImportationFrom.updateSelectedImportations(data.selectedRows);
            },
            selectAll: function (event, data) {
                copyImportationFrom.updateSelectedImportations(data.selectedRows);
            }
        });
    },
    updateSelectedImportations: function (selectedRows) {
        $("#ImportationIds", copyImportationFrom.context).val(_.pluck(selectedRows, "Id").join());
    }
};

$(document).ready(function () {
    if (copyImportationFrom.context.length > 0) {
        copyImportationFrom.initialize();
    }
});